<?php

namespace app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Student extends Model 
{

    protected $table = 'student';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('ci', 'first_name', 'last_name_p', 'last_name_m', 'registry_number');

    public function programs()
    {
        return $this->belongsToMany('app\Models\Program', 'program_id');
    }

}